<?php

use Modules\CodeCraftModifiersPlus\Http\Controllers\CodeCraftModifiersPlusController;

Route::middleware(['web', 'SetSessionData', 'auth', 'language', 'timezone', 'AdminSidebarMenu'])
    ->prefix('codecraftmodifiersplus')
    ->group(function() {
        Route::get('/', [CodeCraftModifiersPlusController::class, 'index']);
        Route::get('/install', 'InstallController@index');
        Route::post('/install', 'InstallController@install');
        Route::get('/install/uninstall', 'InstallController@uninstall');
        Route::get('/install/update', 'InstallController@update');
        Route::get('/modifiers-sets', 'CodeCraftModifiersPlus@index');
        Route::get('/create-modifier', [CodeCraftModifiersPlusController::class, 'create_modifier'])->name('create_modifier');
        Route::post('/store-modifier', [CodeCraftModifiersPlusController::class, 'store_modifier'])->name('store_modifier');
        Route::get('/product-to-modifier', [CodeCraftModifiersPlusController::class, 'getProductsWithoutVariationsModifier'])->name('getProductsWithoutVariationsModifier');
        Route::get('/modifier-row/{product_id}', [CodeCraftModifiersPlusController::class, 'modifier_row'])->name('modifier_row');
        Route::get('/index-modifier', [CodeCraftModifiersPlusController::class, 'index_modifiers'])->name('index_modifiers');
    });