<?php

namespace Modules\CodeCraftModifiersPlus\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Menu;
use App\Utils\ModuleUtil;
class DataController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Response
     */



    public function superadmin_package()
    {
        return [
            [
                'name' => 'codecraftmodifiersplus_module',
                'label' => __('Modificadores Plus'),
                'default' => false
            ]
        ];
    }

    /* Module menu*/
    public function modifyAdminMenu()
    {


        $business_id = session()->get('user.business_id');
        $module_util = new ModuleUtil();
        $is_codecraftmodifiersplus_enabled = (boolean)$module_util->hasThePermissionInSubscription($business_id, 'codecraftmodifiersplus_module', 'superadmin_package');
       
        if($is_codecraftmodifiersplus_enabled){
            $menu = Menu::instance('admin-sidebar-menu');
            if (auth()->user()->can('codecraftmodifiersplus.view')) {
                $menu->dropdown(
                    __('codecraftmodifiersplus::lang.codecraftmodifiersplus'),
                    function ($sub) {
                        $sub->url(
                            action('\Modules\CodeCraftModifiersPlus\Http\Controllers\CodeCraftModifiersPlusController@index'),
                            __('codecraftmodifiersplus::lang.list'),
                            ['icon' => '', 'active' => request()->segment(1) == 'codecraftmodifiersplus' ]
                        );
                    },
					['icon' => 'fa fas fa-hamburger', 'style' => 'background-color: yellow !important;']
    
                )->order(86);
    
            }
        }
    }

    public function user_permissions()
    {
        return [

            [
                'value' => 'codecraftmodifiersplus.view',
                'label' =>  __('codecraftmodifiersplus::lang.view'),
                'default' => false
            ],

            [
                'value' => 'codecraftmodifiersplus.create',
                'label' =>  __('codecraftmodifiersplus::lang.create'),
                'default' => false
            ],
            [
                'value' => 'codecraftmodifiersplus.edit',
                'label' => __('codecraftmodifiersplus::lang.edit'),
                'default' => false
            ],
            [
                'value' => 'codecraftmodifiersplus.delete',
                'label' =>  __('codecraftmodifiersplus::lang.delete'),
                'default' => false
            ],

            [
                'value' => 'codecraftmodifiersplus.add_Collection',
                'label' => __('codecraftmodifiersplus::lang.add_Collection'),
                'default' => false
            ],

            [
                'value' => 'codecraftmodifiersplus.delete_Collection',
                'label' => __('codecraftmodifiersplus::lang.delete_Collection'),
                'default' => false
            ],



            [
                'value' => 'codecraftmodifiersplus.system_add',
                'label' => __('codecraftmodifiersplus::lang.system_add'),
                'default' => false
            ],
             [
                'value' => 'codecraftmodifiersplus.system_edit',
                'label' => __('codecraftmodifiersplus::lang.system_edit'),
                'default' => false
            ],
             [
                'value' => 'codecraftmodifiersplus.system_delete',
                'label' => __('codecraftmodifiersplus::lang.system_delete'),
                'default' => false
            ],

        ];
    }
    public function index()
    {
        return view('CodeCraftModifiersPlus::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Response
     */
    public function create()
    {
        return view('codecraftmodifiersplus::create');
    }



}
