<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('variations', function (Blueprint $table) {
            // Agregar columna modifier_qty como decimal con 10 dígitos en total y 2 decimales
            $table->decimal('modifier_qty', 10, 2)->nullable();
            
            // Agregar columna modifier_product como bigInteger para almacenar IDs largos
            $table->bigInteger('modifier_product')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('variations', function (Blueprint $table) {
            $table->dropColumn('modifier_qty');
            $table->dropColumn('modifier_product');
        });
    }
};
